/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.blocks;

import com.minecolonies.api.blocks.AbstractBlockMinecoloniesRack;
import com.minecolonies.api.blocks.types.RackType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class BlockMinecoloniesRack
extends AbstractBlockMinecoloniesRack<BlockMinecoloniesRack> {
    private static final float BLOCK_HARDNESS = 10.0f;
    private static final String BLOCK_NAME = "blockminecoloniesrack";
    private static final float RESISTANCE = Float.POSITIVE_INFINITY;
    private static final VoxelShape SHAPE = Shapes.m_83048_((double)0.1, (double)0.1, (double)0.1, (double)0.9, (double)0.9, (double)0.9);

    public BlockMinecoloniesRack() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(10.0f, Float.POSITIVE_INFINITY));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)VARIANT, (Comparable)((Object)RackType.DEFAULT)));
        this.setRegistryName("minecolonies".toLowerCase() + ":blockminecoloniesrack");
    }

    public boolean m_7420_(BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return true;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return Shapes.m_83144_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level worldIn = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = this.m_49966_();
        BlockEntity entity = worldIn.m_7702_(pos);
        if (!(entity instanceof TileEntityRack)) {
            return super.m_5573_(context);
        }
        return BlockMinecoloniesRack.getPlacementState(state, entity, pos);
    }

    public static BlockState getPlacementState(BlockState state, BlockEntity entity, BlockPos pos) {
        AbstractTileEntityRack rack = (AbstractTileEntityRack)entity;
        if (rack.isEmpty() && (rack.getOtherChest() == null || rack.getOtherChest().isEmpty())) {
            if (rack.getOtherChest() != null) {
                state.m_61124_((Property)FACING, (Comparable)BlockPosUtil.getFacing(pos, rack.getNeighbor()));
                if (rack.isMain()) {
                    return (BlockState)state.m_61124_(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.DEFAULTDOUBLE));
                }
                return (BlockState)state.m_61124_(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.EMPTYAIR));
            }
            return (BlockState)state.m_61124_(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.DEFAULT));
        }
        if (rack.getOtherChest() != null) {
            state.m_61124_((Property)FACING, (Comparable)BlockPosUtil.getFacing(pos, rack.getNeighbor()));
            if (rack.isMain()) {
                return (BlockState)state.m_61124_(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.FULLDOUBLE));
            }
            return (BlockState)state.m_61124_(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.EMPTYAIR));
        }
        return (BlockState)state.m_61124_(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.FULL));
    }

    @Deprecated
    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Deprecated
    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState stateIn, Direction facing, BlockState state, LevelAccessor worldIn, BlockPos currentPos, BlockPos pos) {
        if (state.m_60734_() instanceof BlockMinecoloniesRack || stateIn.m_60734_() instanceof BlockMinecoloniesRack) {
            BlockEntity rack2;
            BlockEntity rack = worldIn.m_7702_(pos);
            if (rack instanceof TileEntityRack) {
                ((AbstractTileEntityRack)rack).neighborChanged(currentPos);
            }
            if ((rack2 = worldIn.m_7702_(currentPos)) instanceof TileEntityRack) {
                ((AbstractTileEntityRack)rack2).neighborChanged(pos);
            }
        }
        return super.m_7417_(stateIn, facing, state, worldIn, currentPos, pos);
    }

    public void m_8101_(BlockState state, ServerLevel worldIn, BlockPos pos, ItemStack stack) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof TileEntityRack) {
            IItemHandlerModifiable handler = ((AbstractTileEntityRack)tileentity).getInventory();
            InventoryUtils.dropItemHandler((IItemHandler)handler, (Level)worldIn, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
        super.m_8101_(state, worldIn, pos, stack);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, pos);
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if ((colony == null || colony.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) && tileEntity instanceof TileEntityRack) {
            TileEntityRack rack = (TileEntityRack)tileEntity;
            if (!worldIn.f_46443_) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)rack, buf -> buf.m_130064_(rack.m_58899_()).m_130064_(rack.getOtherChest() == null ? BlockPos.f_121853_ : rack.getOtherChest().m_58899_()));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockState tempState = state;
        tempState = (BlockState)tempState.m_61124_((Property)VARIANT, (Comparable)((Object)RackType.DEFAULT));
        if (placer != null) {
            tempState = (BlockState)tempState.m_61124_((Property)FACING, (Comparable)placer.m_6350_().m_122424_());
        }
        worldIn.m_7731_(pos, tempState, 2);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, VARIANT});
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new TileEntityRack(blockPos, blockState);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((ItemLike)this, 1));
        return drops;
    }

    public void m_6810_(BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileEntity = worldIn.m_7702_(pos);
            if (tileEntity instanceof TileEntityRack) {
                TileEntityRack tileEntityRack = (TileEntityRack)tileEntity;
                InventoryUtils.dropItemHandler((IItemHandler)tileEntityRack.getInventory(), worldIn, tileEntityRack.m_58899_().m_123341_(), tileEntityRack.m_58899_().m_123342_(), tileEntityRack.m_58899_().m_123343_());
                worldIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }
}

